/*
 Copyright (c) 2011 Arduino.  All right reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// 2015-06-18 analogReadEx reads at ~660 kHz

#include "Arduino.h"

#ifdef __cplusplus
extern "C" {
#endif

#define NOP __asm__ __volatile__ ("nop\n\t")

void changeChannel(unsigned long int ulPin)
{
  static unsigned long int previousSelectedChannel = -1;
  
  if (ulPin < A0)
  {
    ulPin += A0;
  }  
  
	  		// Enable the corresponding channel
        unsigned long int ulChannel = g_APinDescription[ulPin].ulADCChannelNumber;
                          
			  if (ulChannel != previousSelectedChannel) {
				
			 	  adc_enable_channel( ADC, ulChannel );
				  if (previousSelectedChannel != -1)
                                {
				  adc_disable_channel( ADC, previousSelectedChannel );
                                }
				  previousSelectedChannel = ulChannel;
			  }

}

unsigned char analogReadEx()
{
                                        
			// Start the ADC
			adc_start( ADC );

			// Wait for end of conversion
			while ((adc_get_status(ADC) & ADC_ISR_DRDY) != ADC_ISR_DRDY)
				;

			// Read the value, 8 bit, obsolete: 12 bit
			return adc_get_latest_value(ADC) / 16;

}


#ifdef __cplusplus
}
#endif
